/*
 * Decompiled with CFR 0.152.
 */
package apicore.message;

import apicore.message.LTVParsingError;
import apicore.util.Utilities;
import java.util.Arrays;

public class IPV6Address {
    private static final int HEX_RADIX = 16;
    public static final int IPV6ADDRESS_BYTES = 16;
    byte[] bytes = new byte[16];

    public IPV6Address(byte[] byArray) {
        this.setBytes(byArray);
    }

    public IPV6Address(String string) {
        this.setBytes(Utilities.decodeHex(string));
    }

    protected void setBytes(byte[] byArray) {
        Arrays.fill(this.bytes, (byte)0);
        int n = byArray.length >= this.bytes.length ? 0 : this.bytes.length - byArray.length;
        int n2 = Math.min(this.bytes.length, byArray.length);
        for (int i = 0; i < n2; ++i) {
            this.bytes[n + i] = byArray[i];
        }
    }

    public String getColonHexString() {
        return Utilities.encodeColonHex(this.bytes);
    }

    public String getHexString() {
        return Utilities.encodeHex(this.bytes);
    }

    public byte[] getByteArrayValue() {
        return this.bytes;
    }

    public static IPV6Address parseIPV6Address(String string) {
        IPV6Address iPV6Address = null;
        String[] stringArray = string.split("\\:");
        if (stringArray.length != 8) {
            throw new LTVParsingError("Invalid format for IPV6 Address: " + string);
        }
        try {
            byte[] byArray = new byte[16];
            for (int i = 0; i < stringArray.length; ++i) {
                int n = Integer.parseInt(stringArray[i], 16);
                byArray[2 * i] = (byte)(n >> 8 & 0xFF);
                byArray[2 * i + 1] = (byte)(n & 0xFF);
            }
            iPV6Address = new IPV6Address(byArray);
        }
        catch (NumberFormatException numberFormatException) {
            throw new LTVParsingError("Invalid format for IPV6 Address: " + string);
        }
        return iPV6Address;
    }
}

